package tm.com
{
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	
	public class TemplateUtils
	{
		public static function callFunctionWithDelay( functionToCall:Function, delay:Number, params:Array = null ):void
		{
			var timer:Timer = new Timer( delay*1000 );
			var timedFunction:Function = function( eventArgs:TimerEvent ):void
			{
				timer.stop();
				functionToCall.apply( this, params );
			};
			timer.addEventListener( 'timer', timedFunction);
			timer.start();
		}
		
		public static function getTEventFromString( eventString:String, bubbles:Object=false, cancelable:Object=false ):TemplateEvent
		{
			if( eventString && eventString.length > 0 ) {
				var eventParts:Array = new Array();
				eventParts = eventString.split( ',' );
				var eventName:String = eventParts[0];
				if( eventName && eventName.length > 0 ) {
					eventParts.splice( 0,1 );
					return new TemplateEvent( eventName, eventParts, bubbles, cancelable );
				} else {
					return null;
				}
			} else {
				return null;
			}
		}
	}
}